//=====================================================================
//
// Copyright Peter Schmitteckert, 2001
// http://www.schmitteckert.com
//
// all rights reserved
//
// pPublished under GPL v2 (GNPublic License version2)
//
// NOTE:
// There is absolutely no WARRANTY. This programm may create
// a wormhole transferring you to another galaxy.
// Use at your own risk.
//
//=====================================================================

#include <qapp.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qbitmap.h>


#include <iostream>
#include <stdlib.h>

#include "Ising.h"
#include "IsingWidget.h"
#include "ControlWidget.h"

int main(int argc, char **argv)
 {
  int sx     = 512;
  int sy     = 512;

  double Temp = .4;
  double h = 0;
  int NumIterPerUpdate;
  unsigned int seed_value = 1;

  if (argc>1) sx = atoi(argv[1]);
  if (argc>2) sy = atoi(argv[2]);

  if (argc>3) Temp = atof(argv[3]);
  if (argc>4) h = atof(argv[4]);
  //if (argc>5) NumIterPerUpdate = atoi(argv[5]);
  //if (argc>6) seed_value = atoi(argv[6]);


   QApplication app(argc, argv);

   // --------------------------------------

   IsingWidget* pIsingWidget = new IsingWidget(sx, sy, Temp, h );

   // Move and resize the IsingWindow object
   // left=200, top=200, width=400, height=300
   pIsingWidget->setGeometry(200,200,sx,sy);
   pIsingWidget->setBackgroundMode( QWidget::NoBackground);

   // Show the window
   pIsingWidget->show();

   // --------------------------------------

   // Create a ControlWindow object
   ControlWidget mainWidget(pIsingWidget);

   // Move and resize the IsingWindow object
   // left=200, top=200, width=400, height=300
   mainWidget.setGeometry(20,20,100,100);

   // --------------------------------------

   // Main window = IsingWindow object
   app.setMainWidget(&mainWidget);
   pIsingWidget->pApplication = &app;

   //app.setMainWidget(&isingWidget);
   //mainWidget.setBackgroundMode( QWidget::NoBackground);
   //isingWidget.setBackgroundMode( QWidget::NoBackground);

   //--------------------------------


   // Show the window
   mainWidget.show();


   // Go to the main loop

   return app.exec();
}

