//=====================================================================
//
// Copyright Peter Schmitteckert, 2001
// http://www.schmitteckert.com
//
// all rights reserved
//
// Published under GPL v2 (GNPublic License version2)
//
// NOTE:
// There is absolutely no WARRANTY. This programm may create
// a wormhole transferring you to another galaxy.
// Use at your own risk.
//
//=====================================================================


//----------------------------------------------
// Ising Window
//----------------------------------------------

#include <qpixmap.h>

#include "IsingWidget.moc"

IsingWidget::IsingWidget(const int sx, const int sy, const double T, const double h)
    : QWidget(), IsingSystem( sx, sy, T, h )
{
    setCaption("Ising Spin System");
    setBackgroundMode(QWidget::NoBackground);

    IsingSystem.Randomize();

#ifdef D_LittleEndian
    pImage = new (unsigned long) [ (GetNx()*GetNy()) / sizeof(unsigned long) ];
    CopyData( reinterpret_cast<const unsigned char*>(IsingSystem.GetDataPointer()) );
#else
    pImage =  reinterpret_cast<const long unsigned int *> ( IsingSystem.GetDataPointer() );
#endif

    pApplication = NULL;

}

IsingWidget::~IsingWidget()
{
#ifdef D_LittleEndian
    delete [] pImage;
#endif
}

int IsingWidget::GetNx() const
{
    return IsingSystem.Nxspins();
}

int IsingWidget::GetNy() const
{
    return IsingSystem.Nyspins();
}

void IsingWidget::setTemperature(const double d)
{
    double Temp = d> 1e-5 ? d : 1e-5;
	cout << "setting Temperature received: " << d << endl;
    IsingSystem.setParameterTemperature( Temp);
}


void IsingWidget::CopyData(const unsigned char* pOrig)
{
    // LittleEndian madness

#ifdef D_LittleEndian
    unsigned char* p = (unsigned char*) pImage;
    for( int i=0; i< GetNy(); ++i)
    {
        for( int j=0; j< GetNx()/32; ++j, p+=4, pOrig+=4 )
        {
            p[0] = pOrig[3];
            p[1] = pOrig[2];
            p[2] = pOrig[1];
            p[3] = pOrig[0];
        }
    }
#endif
}

void IsingWidget::paintEvent(QPaintEvent *)
{
     QBitmap bitmapA( GetNx(), GetNy(),  reinterpret_cast<const uchar*>( pImage ) );
     bitBlt( this, 0, 0, &bitmapA, 0,0, GetNx(), GetNy(), CopyROP );
}

void IsingWidget::startSimulation( void )
{
    bSimulate=true;
    cout << "Starting Simulation" << endl;
    while( bSimulate )
    {
        IsingSystem.Simulate( 1 );
        CopyData(reinterpret_cast<const unsigned char*>(IsingSystem.GetDataPointer()));
        update();
        if( pApplication != NULL)
            pApplication->processEvents();
    }
}

void IsingWidget::stopSimulation(void)
{
    bSimulate = false;
    cout << "Going to stop Simulation." << endl;
}

