//=====================================================================
//
// Copyright Peter Schmitteckert, 2001
// http://www.schmitteckert.com
//
// all rights reserved
//
// pPublished under GPL v2 (GNPublic License version2)
//
// NOTE:
// There is absolutely no WARRANTY. This programm may create
// a wormhole transferring you to another galaxy.
// Use at your own risk.
//
//=====================================================================

#include "IsingWidget.h"
#include "ControlWidget.moc"

const int IntScaling = 1000;

ControlWidget::ControlWidget(IsingWidget* ps) : QWidget( )
{
    setMinimumSize( 240, 200 );
    pIsingWidget = ps;


    quit = new QPushButton( "Quit", this, "quit" );
    quit->setGeometry( 10, 10, 75, 30 );
    quit->setFont( QFont( "Times", 18, QFont::Bold ) );
    connect( quit, SIGNAL(clicked()), this, SLOT(quitWidget()) );

    startSim = new QPushButton( "Start", this, "starting" );
    startSim->setGeometry( 85, 10, 75, 30 );
    startSim->setFont( QFont( "Times", 18, QFont::Bold ) );
    connect( startSim, SIGNAL(clicked()), pIsingWidget, SLOT(startSimulation()) );


    endSim = new QPushButton( "End", this, "ending");
    endSim->setGeometry( 160, 10, 75, 30 );
    endSim->setFont( QFont( "Times", 18, QFont::Bold ) );
    connect( endSim, SIGNAL(clicked()), pIsingWidget, SLOT(stopSimulation()) );

    lcd  = new MyLcd( 5, this, "lcd" );
    lcd->move( 10, quit->y() + quit->height() + 10 );


    sBar = new QScrollBar( 0, IntScaling,                       // range
                           1, 10,                       // line/page steps
                           250,                           // inital value
                           QScrollBar::Horizontal,      // orientation
                           this, "scrollbar" );

    connect( sBar, SIGNAL(valueChanged(int)), lcd, SLOT(changeValue(int)) );
    connect( lcd, SIGNAL(valueChanged(const double)), pIsingWidget, SLOT( setTemperature(const double)) );
   lcd->changeValue(250);

    // ------------------



}

ControlWidget::~ControlWidget()
{
    delete pIsingWidget;
};

void ControlWidget::resizeEvent( QResizeEvent * )
{
    sBar->setGeometry( 10, height() - 10 - 16, width() - 20, 16 );
    lcd->resize( sBar->width(), sBar->y() - lcd->y() - 5 );
}

void ControlWidget::quitWidget()
{
    pIsingWidget->stopSimulation();
	qApp->quit();
}

//----------------------------------------

MyLcd::MyLcd( uint nDigits, QWidget* parent, const char* pName ) : QLCDNumber( nDigits, parent, pName )
{

}


void MyLcd::changeValue(int n)
{
    value = 2.5 * double(n) / double(IntScaling);
    QLCDNumber::display(value);
    emit valueChanged(value);
    cout << "Change Temperature emitted." << endl;
}

