//=====================================================================
//
// Copyright Peter Schmitteckert, 2001
// http://www.schmitteckert.com
//
// all rights reserved
//
// pPublished under GPL v2 (GNPublic License version2)
//
// NOTE:
// There is absolutely no WARRANTY. This programm may create
// a wormhole transferring you to another galaxy.
// Use at your own risk.
//
//=====================================================================

#ifndef INCLUDES_ControlWidget
#define INCLUDES_ControlWidget

#include <qwidget.h>
#include <qpushbutton.h>
#include <qscrollbar.h>
#include <qlcdnumber.h>
#include <qfont.h>


class MyLcd :   public QLCDNumber
{
  Q_OBJECT

  private :
    double value;

  protected:
    void display(int n);

  public:

    MyLcd( uint nDigits, QWidget* parent, const char* pName );
   ~MyLcd() {};

    double getValue() const
    {
            return value;
    }

  public slots:
    void changeValue(int);

  signals:
    void valueChanged( const double d);

};

//----------------------------------------------
// Control Window
//----------------------------------------------

class ControlWidget : public QWidget
{
  Q_OBJECT

 public:

   ControlWidget(IsingWidget* s);
   virtual ~ControlWidget();

 protected:

   //void mousePressEvent(QMouseEvent *);
   //void mouseMoveEvent(QMouseEvent *);
   void resizeEvent( QResizeEvent * );

  private:

    QPushButton *quit;
    QPushButton *startSim;
    QPushButton *endSim;
    QScrollBar  *sBar;
    MyLcd  *lcd;

    IsingWidget* pIsingWidget;

  private slots:
    void quitWidget();


};


#endif // INCLUDE_ControlWidget

