#ifndef INCLUDES_Issy_Ising_
#define INCLUDES_Issy_Ising_

#include <math.h>
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>


typedef unsigned long BASE;
typedef BASE *IsingChain;
typedef BASE *BASEp;

const int BaseSize8 = sizeof(BASE);
const int BaseSize  = 8*BaseSize8;
const BASE Mask_A   = 0xaaaaaaaa;
const BASE Mask_B   = 0x55555555;
const BASE Mask_AB  = 0xffffffff;
const BASE Mask_Lsb = 1;
const BASE Mask_Msb = (1<<(BaseSize-1));



class Ising2d
{
  
  private :
    double      T; // Temparatur T
    double      H; // external magnetic field;
    double      h; // external+internal magnetic field;

    int         N_xspins, N_yspins, N_x, N_y;
    double      N_spins;

    IsingChain *pChain;
    IsingChain  Chainb0, Chainb1,Chainb2;
    BASE        W[4][4];  // Metropolis - Gewichte
    //          W[bbx][bby][local Spin]
    // stream     *stream;  // Input-File f"ur Daten

    void  update_A( IsingChain s, IsingChain by1, IsingChain by2 );
    void  update_B( IsingChain s, IsingChain by1, IsingChain by2 );


    void  calc_W( );

  public :
    Ising2d(int nx, int ny, double TT=0.0, double hh=0.0);
    ~Ising2d();

    void  setParameterTemperature( const double TT )  ;
    void  setMagneticField( const double hh ) ;

    int Nxspins(void) const { return N_xspins;};
    int Nyspins(void) const { return N_yspins;};

    void Randomize();

    void Simulate( const int N_Iterationen=100);

    void out(ostream&);

    void bbond(int j);
    int  M();
    const BASE* GetDataPointer();

    friend void swap( BASEp &, BASEp &);
 };

#endif /* INCLUDES_Issy_Ising_ */
