//=====================================================================
//
// Copyright Peter Schmitteckert, 2001
// http://www.schmitteckert.com
//
// all rights reserved
//
// pPublished under GPL v2 (GNPublic License version2)
//
// NOTE:
// There is absolutely no WARRANTY. This programm may create
// a wormhole transferring you to another galaxy.
// Use at your own risk.
//
//=====================================================================

#ifndef INCLUDES_IsingWidget
#define INCLUDES_IsingWidget

#include <qapplication.h>
#include <qwidget.h>
#include <qpainter.h>
#include <qbitmap.h>

#include "Ising.h"



//----------------------------------------------
// Ising Widget
//----------------------------------------------


class IsingWidget : public QWidget // Widget
{
  Q_OBJECT
  public:
    // Constructor, Parent is always 0 for windows
    IsingWidget(const int sx, const int sy, const double T=0.4, const double h=0);

    ~IsingWidget();

    int GetNx() const;
    int GetNy() const;
    QApplication* pApplication;

  public slots:

    void startSimulation();  // tartSimulation( int NumIterationsPerUpdate=1);
    void stopSimulation();
    void setTemperature(const double d);

  protected:
   // This function will be called when the user presses a mouse button
   //void mousePressEvent(QMouseEvent *);
   //void mouseMoveEvent(QMouseEvent *);
   void paintEvent(QPaintEvent *);

   private:

    volatile bool bSimulate;

    const unsigned long* pImage;   // avoid misalignments
    void CopyData(const unsigned char* pOrig);

    int NumIterPerUpdate;

    //double Temperature;
    //double MagneticFieldExternal;
    Ising2d IsingSystem;
    QBitmap* pBitmapB;
};



#endif
